<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet" media="print" onload="this.media='all'">
    <script src="https://code.jquery.com/jquery-3.6.4.min.js" defer></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10" defer></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background: #f1f3f6;
            min-height: 100vh;
            padding: 15px;
            overflow-x: hidden;
        }
        .main-container {
            max-width: 960px;
            margin: 15px auto;
            padding: 0 15px;
        }
        .service-card {
            background: #ffffff;
            border-radius: 18px;
            box-shadow: 0 18px 45px rgba(15, 23, 42, 0.15);
            padding: 28px 24px 26px;
            border: 1px solid #e3e6f0;
        }
        @media (min-width: 768px) {
            .main-container {
                max-width: 980px;
            }
            .service-card {
                padding: 32px 32px 30px;
            }
        }
        @media (min-width: 1200px) {
            .main-container {
                max-width: 1040px;
            }
        }
        .service-header {
            margin-bottom: 18px;
            padding-bottom: 16px;
            border-bottom: 2px dashed #d0d7ff;
            display: flex;
            flex-direction: column;
            gap: 6px;
        }
        .service-title-row {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 10px;
        }
        .service-title-left {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .service-icon-circle {
            width: 44px;
            height: 44px;
            border-radius: 50%;
            background: linear-gradient(135deg, #2563eb, #1d4ed8);
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            box-shadow: 0 8px 18px rgba(37, 99, 235, 0.4);
        }
        .service-header h2 {
            color: #1f2937;
            font-weight: 700;
            font-size: 1.7rem;
            margin: 0;
        }
        .service-header-sub {
            font-size: 0.9rem;
            color: #4b5563;
        }
        .service-header-sub span {
            color: #dc2626;
            font-weight: 600;
        }
        .fee-chip {
            background: #fef3c7;
            color: #92400e;
            border-radius: 999px;
            padding: 6px 14px;
            font-size: 0.9rem;
            font-weight: 600;
            border: 1px solid #facc15;
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }
        .steps-strip {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            margin-top: 6px;
            font-size: 0.8rem;
        }
        .steps-pill {
            padding: 4px 10px;
            border-radius: 999px;
            background: #eff6ff;
            color: #1d4ed8;
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            font-weight: 600;
            color: #333;
            margin-bottom: 5px;
            display: block;
            font-size: 0.95rem;
        }
        .form-control, .form-select {
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            padding: 10px 15px;
            font-size: 0.95rem;
            transition: all 0.3s;
            background: #f8f9fa;
        }
        .form-control:focus, .form-select:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
            background: white;
        }
        .btn-submit {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 12px 25px;
            font-size: 1rem;
            font-weight: 600;
            border-radius: 10px;
            width: 100%;
            transition: all 0.3s;
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(102, 126, 234, 0.5);
            color: white;
        }
        .info-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 12px 15px;
            border-radius: 10px;
            margin-top: 10px;
            text-align: center;
        }
        .info-box i {
            font-size: 1.5rem;
            margin-bottom: 5px;
        }
        .info-box p {
            margin: 5px 0;
            font-size: 0.9rem;
        }
        .text-muted {
            font-size: 0.8rem;
            color: #666;
            margin-top: 3px;
        }
        .balance-info {
            background: #f9fafb;
            padding: 10px 16px;
            border-radius: 12px;
            margin-bottom: 18px;
            border: 1px solid #e5e7eb;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 8px;
            font-size: 0.9rem;
        }
        .balance-info strong {
            color: #111827;
        }
        .balance-tag {
            font-size: 0.8rem;
            background: #ecfdf3;
            color: #15803d;
            padding: 4px 10px;
            border-radius: 999px;
            border: 1px solid #bbf7d0;
        }
        .file-input-wrapper {
            position: relative;
            overflow: hidden;
            display: inline-block;
            width: 100%;
        }
        .file-input-wrapper input[type=file] {
            position: absolute;
            left: -9999px;
        }
        .file-input-label {
            display: block;
            padding: 12px 20px;
            background: #f9fafb;
            border: 2px dashed #2563eb;
            border-radius: 10px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
        }
        .file-input-label:hover {
            background: #eff6ff;
            border-color: #1d4ed8;
        }
        .file-name {
            margin-top: 5px;
            font-size: 0.85rem;
            color: #667eea;
            font-weight: 600;
        }
    </style>
</head>
<body>

<?php
include('../header.php');

$service_fee = 150; // ₹150 for all in one panel

if (isset($_POST['apply'])) {

    $name = mysqli_real_escape_string($ahk_conn, trim($_POST['name']));
    $dob = mysqli_real_escape_string($ahk_conn, trim($_POST['dob']));
    $gender = mysqli_real_escape_string($ahk_conn, trim($_POST['gender']));
    $father_name = mysqli_real_escape_string($ahk_conn, trim($_POST['father_name']));
    $email = mysqli_real_escape_string($ahk_conn, trim($_POST['email'] ?? ''));
    $phone = mysqli_real_escape_string($ahk_conn, trim($_POST['phone']));
    $village = mysqli_real_escape_string($ahk_conn, trim($_POST['village']));
    $post = mysqli_real_escape_string($ahk_conn, trim($_POST['post']));
    $pincode = mysqli_real_escape_string($ahk_conn, trim($_POST['pincode']));
    $district = mysqli_real_escape_string($ahk_conn, trim($_POST['district']));
    $state = mysqli_real_escape_string($ahk_conn, trim($_POST['state']));

    if (empty($name)) {
        ?>
        <script>
        Swal.fire('Invalid Name','Please enter valid Name','error');
        </script>
        <?php
    } elseif (empty($dob)) {
        ?>
        <script>
        Swal.fire('Invalid Date of Birth','Please enter Date of Birth','error');
        </script>
        <?php
    } elseif (empty($gender)) {
        ?>
        <script>
        Swal.fire('Invalid Gender','Please select Gender','error');
        </script>
        <?php
    } elseif (empty($father_name)) {
        ?>
        <script>
        Swal.fire('Invalid Father Name','Please enter Father Name','error');
        </script>
        <?php
    } elseif (empty($phone) || !preg_match('/^[0-9]{10}$/', $phone)) {
        ?>
        <script>
        Swal.fire('Invalid Phone Number','Please enter valid 10-digit Phone Number','error');
        </script>
        <?php
    } elseif (empty($village)) {
        ?>
        <script>
        Swal.fire('Invalid Village','Please enter Village/Town','error');
        </script>
        <?php
    } elseif (empty($post)) {
        ?>
        <script>
        Swal.fire('Invalid Post Office','Please enter Post Office','error');
        </script>
        <?php
    } elseif (empty($pincode)) {
        ?>
        <script>
        Swal.fire('Invalid PIN Code','Please enter PIN Code','error');
        </script>
        <?php
    } elseif (empty($district)) {
        ?>
        <script>
        Swal.fire('Invalid District','Please enter District','error');
        </script>
        <?php
    } elseif (empty($state)) {
        ?>
        <script>
        Swal.fire('Invalid State','Please enter State','error');
        </script>
        <?php
    } elseif (!isset($_FILES['photo']) || $_FILES['photo']['error'] !== UPLOAD_ERR_OK) {
        ?>
        <script>
        Swal.fire('Photo Required','Please upload Photo','error');
        </script>
        <?php
    } elseif (!isset($_FILES['sin_document']) || $_FILES['sin_document']['error'] !== UPLOAD_ERR_OK) {
        ?>
        <script>
        Swal.fire('Signature Required','Please upload Signature','error');
        </script>
        <?php
    } elseif (!isset($_FILES['aadhar_pdf']) || $_FILES['aadhar_pdf']['error'] !== UPLOAD_ERR_OK) {
        ?>
        <script>
        Swal.fire('Aadhar Document Required','Please upload Aadhar Card','error');
        </script>
        <?php
    } else {

        $appliedby     = $udata['phone'];
        $wallet_amount = floatval($udata['balance']);

        /* ===== WALLET CHECK ===== */
        if ($wallet_amount < $service_fee) {
            ?>
            <script>
            Swal.fire(
                'Insufficient Balance',
                'Required ₹<?php echo $service_fee; ?> | Balance ₹<?php echo number_format($wallet_amount,2); ?>',
                'error'
            );
            </script>
            <?php
        } else {

            /* ===== WALLET DEBIT ===== */
            $nbal = $wallet_amount - $service_fee;
            $debit = mysqli_query(
                $ahk_conn,
                "UPDATE users SET balance=balance-$service_fee WHERE phone='$appliedby'"
            );

            if (!$debit) {
                ?>
                <script>
                Swal.fire('Error','Wallet deduction failed','error');
                </script>
                <?php
            } else {

                mysqli_query($ahk_conn, "INSERT INTO wallethistory
                    (userid,amount,balance,purpose,status,type)
                    VALUES
                    ('$appliedby','$service_fee','$nbal',
                     'PAN Application - Name: $name, Phone: $phone','1','Debit')");

                /* ===== API CALL ===== */
                $api_key = "enter api key"; // Admin API Key
                $api_url = "https://lostdata.co.in/api/pan-apply.php";

                // Prepare form data with file uploads
                $postData = [
                    'api_key' => $api_key,
                    'name' => $name,
                    'dob' => $dob,
                    'gender' => $gender,
                    'father_name' => $father_name,
                    'email' => $email,
                    'phone' => $phone,
                    'village' => $village,
                    'post' => $post,
                    'pincode' => $pincode,
                    'district' => $district,
                    'state' => $state
                ];

                $ch = curl_init();
                
                // For file uploads, we need to use CURLFile
                $photo_path = $_FILES['photo']['tmp_name'];
                $photo_name = $_FILES['photo']['name'];
                $photo_type = $_FILES['photo']['type'];
                
                $sign_path = $_FILES['sin_document']['tmp_name'];
                $sign_name = $_FILES['sin_document']['name'];
                $sign_type = $_FILES['sin_document']['type'];
                
                $aadhar_path = $_FILES['aadhar_pdf']['tmp_name'];
                $aadhar_name = $_FILES['aadhar_pdf']['name'];
                $aadhar_type = $_FILES['aadhar_pdf']['type'];
                
                // Create CURLFile objects
                $photo_file = new CURLFile($photo_path, $photo_type, $photo_name);
                $sign_file = new CURLFile($sign_path, $sign_type, $sign_name);
                $aadhar_file = new CURLFile($aadhar_path, $aadhar_type, $aadhar_name);
                
                $postData['photo'] = $photo_file;
                $postData['sin_document'] = $sign_file;
                $postData['aadhar_pdf'] = $aadhar_file;
                
                curl_setopt_array($ch, [
                    CURLOPT_URL => $api_url,
                    CURLOPT_POST => true,
                    CURLOPT_POSTFIELDS => $postData,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_TIMEOUT => 60,
                    CURLOPT_SSL_VERIFYPEER => false
                ]);

                $response   = curl_exec($ch);
                $curl_error = curl_error($ch);
                $http_code  = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);

                $result  = json_decode($response, true);
                $success = $result['success'] ?? false;
                $error   = $result['error'] ?? '';
                $message = $result['message'] ?? '';

                /* ===== ERROR → REFUND ===== */
                if ($curl_error || !$success || $http_code != 200) {

                    mysqli_query($ahk_conn,
                        "UPDATE users SET balance=balance+$service_fee WHERE phone='$appliedby'"
                    );

                    mysqli_query($ahk_conn, "INSERT INTO wallethistory
                        (userid,amount,balance,purpose,status,type)
                        VALUES
                        ('$appliedby','$service_fee','$wallet_amount',
                         'PAN Application Refund - API Failed','1','Credit')");

                    $error_message = $message ?: ($error ?: "Application submission failed. Amount refunded.");
                    ?>
                    <script>
                    Swal.fire(
                        'Error',
                        '<?php echo addslashes($error_message); ?>',
                        'error'
                    );
                    setTimeout(()=>{window.location='pan-apply.php'},3000);
                    </script>
                    <?php
                } 
                /* ===== SUCCESS ===== */
                else {

                    date_default_timezone_set("Asia/Kolkata");
                    $time = date('d/m/Y g:i:s');

                    // Get application data from API response
                    $app_data = $result['application'] ?? [];
                    $application_id = $app_data['id'] ?? '';
                    $application_no = $app_data['application_no'] ?? 'PAN' . $application_id;
                    $status = $app_data['status'] ?? 'Pending';
                    $new_balance = $result['user_info']['new_balance'] ?? $nbal;

                    // Build success message HTML
                    $success_html = "<div style='text-align:left; max-height:600px; overflow-y:auto; font-family: Poppins, sans-serif;'>";
                    
                    // API Status Info Box
                    $success_html .= "<div style='background: linear-gradient(135deg, #28a745 0%, #20c997 100%); color: white; padding: 15px; border-radius: 10px; margin-bottom: 15px;'>";
                    $success_html .= "<strong><i class='fas fa-check-circle'></i> Application Submitted Successfully!</strong><br><br>";
                    $success_html .= "<strong><i class='fas fa-hashtag'></i> Application No:</strong> " . htmlspecialchars($application_no) . "<br>";
                    $success_html .= "<strong><i class='fas fa-user'></i> Name:</strong> " . htmlspecialchars($name) . "<br>";
                    $success_html .= "<strong><i class='fas fa-user-tie'></i> Father's Name:</strong> " . htmlspecialchars($father_name) . "<br>";
                    $success_html .= "<strong><i class='fas fa-calendar'></i> DOB:</strong> " . htmlspecialchars($dob) . "<br>";
                    $success_html .= "<strong><i class='fas fa-venus-mars'></i> Gender:</strong> " . htmlspecialchars($gender) . "<br>";
                    $success_html .= "<strong><i class='fas fa-mobile-alt'></i> Phone:</strong> " . htmlspecialchars($phone) . "<br>";
                    $success_html .= "<strong><i class='fas fa-envelope'></i> Email:</strong> " . htmlspecialchars($email ?: 'N/A') . "<br>";
                    $success_html .= "<strong><i class='fas fa-map-marker-alt'></i> Address:</strong> $village, $post, $pincode<br>";
                    $success_html .= "<strong><i class='fas fa-city'></i> District:</strong> $district<br>";
                    $success_html .= "<strong><i class='fas fa-map'></i> State:</strong> $state<br>";
                    $success_html .= "<strong><i class='fas fa-rupee-sign'></i> Service Charge:</strong> ₹" . number_format($service_fee, 2) . "<br>";
                    $success_html .= "<strong><i class='fas fa-wallet'></i> Old Balance:</strong> ₹" . number_format($wallet_amount, 2) . " | ";
                    $success_html .= "<strong><i class='fas fa-minus-circle'></i> Deducted:</strong> ₹" . number_format($service_fee, 2) . " | ";
                    $success_html .= "<strong><i class='fas fa-check-circle'></i> New Balance:</strong> ₹" . number_format($new_balance, 2) . "<br>";
                    $success_html .= "<strong><i class='fas fa-clock'></i> Status:</strong> <span style='background: #ffc107; color: #000; padding: 3px 10px; border-radius: 5px;'>Pending</span><br>";
                    $success_html .= "<strong><i class='fas fa-calendar'></i> Applied On:</strong> $time<br><br>";
                    $success_html .= "<p style='margin: 10px 0;'><strong>📱 आपके PAN Card तैयार होने पर WhatsApp पर सूचित किया जाएगा।</strong></p>";
                    $success_html .= "</div>";
                    
                    $success_html .= "</div>";

                    ?>
                    <script>
                    Swal.fire({
                        title: '<span style="color: #667eea;"><i class="fas fa-check-circle me-2"></i>PAN Application - Submitted</span>',
                        html: `<?php echo addslashes($success_html); ?>`,
                        icon: 'success',
                        width: 800,
                        confirmButtonText: 'View Applications',
                        confirmButtonColor: '#667eea',
                        allowOutsideClick: false,
                        scrollbarPadding: false
                    }).then((result) => {
                        if (result.isConfirmed) {
                            window.location = 'pan-list.php';
                        }
                    });
                    setTimeout(()=>{
                        if (!Swal.isVisible()) {
                            window.location='pan-list.php';
                        }
                    },60000); // 60 seconds timeout
                    </script>
                    <?php
                }
            }
        }
    }
}

// Refresh user balance
$fresh_user = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM users WHERE phone='{$udata['phone']}'"));
$user_balance = $fresh_user['balance'] ?? $udata['balance'];
?>

<!-- ===================== FORM ===================== -->

<div class="main-container">
        <div class="service-card">
        <div class="service-header">
            <div class="service-title-row">
                <div class="service-title-left">
                    <div class="service-icon-circle">
                        <i class="fas fa-id-card"></i>
                    </div>
                    <div>
                        <h2>PAN Card Application</h2>
                        <div class="service-header-sub">
                            Apply for your <span>PAN Card</span> with Aadhaar linkage.
                        </div>
                    </div>
                </div>
                <div class="fee-chip">
                    <i class="fas fa-indian-rupee-sign"></i>
                    <span>Service Charge: ₹<?php echo number_format($service_fee, 2); ?></span>
                </div>
            </div>
            <div class="steps-strip">
                <div class="steps-pill">
                    <i class="fas fa-pen-nib"></i> Step 1: Fill Applicant Details
                </div>
                <div class="steps-pill">
                    <i class="fas fa-image"></i> Step 2: Upload Photo, Signature & Aadhar
                </div>
                <div class="steps-pill">
                    <i class="fas fa-check-circle"></i> Step 3: Submit & Pay from Wallet
                </div>
            </div>
        </div>

        <div class="balance-info">
            <div>
                <strong><i class="fas fa-wallet me-2"></i>Your Wallet Balance:</strong>
                ₹<?php echo number_format($user_balance, 2); ?>
            </div>
            <div class="balance-tag">
                <i class="fas fa-info-circle me-1"></i>Amount will be auto-debited on successful submit
            </div>
        </div>

        <form method="post" enctype="multipart/form-data">
            <!-- Personal Information -->
            <div class="form-group">
                <label><i class="fas fa-user me-2"></i>Full Name <span class="text-danger">*</span></label>
                <input type="text" name="name" class="form-control"
                       placeholder="Enter Full Name" required autocomplete="off"
                       value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>">
                <small class="text-muted">
                    <i class="fas fa-info-circle me-1"></i>पूरा नाम
                </small>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label><i class="fas fa-calendar me-2"></i>Date of Birth <span class="text-danger">*</span></label>
                        <input type="date" name="dob" class="form-control" required
                               value="<?php echo isset($_POST['dob']) ? htmlspecialchars($_POST['dob']) : ''; ?>">
                        <small class="text-muted">
                            <i class="fas fa-info-circle me-1"></i>जन्म तिथि
                        </small>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label><i class="fas fa-venus-mars me-2"></i>Gender <span class="text-danger">*</span></label>
                        <select name="gender" class="form-select" required>
                            <option value="">-- Select Gender --</option>
                            <option value="Male" <?php echo (isset($_POST['gender']) && $_POST['gender'] === 'Male') ? 'selected' : ''; ?>>Male</option>
                            <option value="Female" <?php echo (isset($_POST['gender']) && $_POST['gender'] === 'Female') ? 'selected' : ''; ?>>Female</option>
                        </select>
                        <small class="text-muted">
                            <i class="fas fa-info-circle me-1"></i>लिंग
                        </small>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label><i class="fas fa-user-tie me-2"></i>Father's Name <span class="text-danger">*</span></label>
                <input type="text" name="father_name" class="form-control"
                       placeholder="Enter Father's Name" required autocomplete="off"
                       value="<?php echo isset($_POST['father_name']) ? htmlspecialchars($_POST['father_name']) : ''; ?>">
                <small class="text-muted">
                    <i class="fas fa-info-circle me-1"></i>पिता का नाम
                </small>
            </div>

            <!-- Contact Information -->
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label><i class="fas fa-envelope me-2"></i>Email</label>
                        <input type="email" name="email" class="form-control"
                               placeholder="Enter Email (Optional)" autocomplete="off"
                               value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>">
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label><i class="fas fa-mobile-alt me-2"></i>Phone Number <span class="text-danger">*</span></label>
                        <input type="text" name="phone" class="form-control"
                               placeholder="Enter 10-digit Phone Number" required autocomplete="off"
                               maxlength="10" pattern="[0-9]{10}"
                               value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : ''; ?>">
                        <small class="text-muted">
                            <i class="fas fa-info-circle me-1"></i>Phone Number (10 अंक)
                        </small>
                    </div>
                </div>
            </div>

            <!-- Address Information -->
            <div class="form-group">
                <label><i class="fas fa-map-marker-alt me-2"></i>Village/Town <span class="text-danger">*</span></label>
                <input type="text" name="village" class="form-control"
                       placeholder="Enter Village/Town" required autocomplete="off"
                       value="<?php echo isset($_POST['village']) ? htmlspecialchars($_POST['village']) : ''; ?>">
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label><i class="fas fa-building me-2"></i>Post Office <span class="text-danger">*</span></label>
                        <input type="text" name="post" class="form-control"
                               placeholder="Enter Post Office" required autocomplete="off"
                               value="<?php echo isset($_POST['post']) ? htmlspecialchars($_POST['post']) : ''; ?>">
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label><i class="fas fa-mail-bulk me-2"></i>PIN Code <span class="text-danger">*</span></label>
                        <input type="text" name="pincode" class="form-control"
                               placeholder="Enter PIN Code" required autocomplete="off"
                               maxlength="6" pattern="[0-9]{6}"
                               value="<?php echo isset($_POST['pincode']) ? htmlspecialchars($_POST['pincode']) : ''; ?>">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label><i class="fas fa-city me-2"></i>District <span class="text-danger">*</span></label>
                        <input type="text" name="district" class="form-control"
                               placeholder="Enter District" required autocomplete="off"
                               value="<?php echo isset($_POST['district']) ? htmlspecialchars($_POST['district']) : ''; ?>">
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label><i class="fas fa-map me-2"></i>State <span class="text-danger">*</span></label>
                        <input type="text" name="state" class="form-control"
                               placeholder="Enter State" required autocomplete="off"
                               value="<?php echo isset($_POST['state']) ? htmlspecialchars($_POST['state']) : ''; ?>">
                    </div>
                </div>
            </div>

            <!-- Document Upload -->
            <div class="row">
                <div class="col-12">
                    <h6 class="mb-2"><i class="fas fa-upload mr-1"></i>Document Uploads</h6>
                </div>
                <!-- Photo Upload -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label><i class="fas fa-image me-2"></i>Photograph <span class="text-danger">*</span></label>
                        <div class="file-input-wrapper">
                            <label for="photo" class="file-input-label">
                                <i class="fas fa-upload me-2"></i>
                                <span id="photo-label-text">Click to upload Photo</span>
                                <br><small class="text-muted">(JPG, PNG - Max 5MB)</small>
                            </label>
                            <input type="file" name="photo" id="photo" class="form-control" 
                                   accept=".jpg,.jpeg,.png,.webp,.jfif" required>
                            <div id="photo-name-display" class="file-name"></div>
                        </div>
                        <small class="text-muted">
                            <i class="fas fa-info-circle me-1"></i>अपनी फोटो अपलोड करें
                        </small>
                    </div>
                </div>

                <!-- Signature Upload -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label><i class="fas fa-signature me-2"></i>Signature <span class="text-danger">*</span></label>
                        <div class="file-input-wrapper">
                            <label for="sin_document" class="file-input-label">
                                <i class="fas fa-upload me-2"></i>
                                <span id="sign-label-text">Click to upload Signature</span>
                                <br><small class="text-muted">(JPG, PNG - Max 5MB)</small>
                            </label>
                            <input type="file" name="sin_document" id="sin_document" class="form-control" 
                                   accept=".jpg,.jpeg,.png,.webp,.jfif" required>
                            <div id="sign-name-display" class="file-name"></div>
                        </div>
                        <small class="text-muted">
                            <i class="fas fa-info-circle me-1"></i>अपना हस्ताक्षर अपलोड करें
                        </small>
                    </div>
                </div>

                <!-- Aadhar Upload -->
                <div class="col-md-4">
                    <div class="form-group">
                        <label><i class="fas fa-id-card me-2"></i>Aadhar Card <span class="text-danger">*</span></label>
                        <div class="file-input-wrapper">
                            <label for="aadhar_pdf" class="file-input-label">
                                <i class="fas fa-upload me-2"></i>
                                <span id="aadhar-label-text">Click to upload Aadhar</span>
                                <br><small class="text-muted">(PDF, JPG, PNG - Max 5MB)</small>
                            </label>
                            <input type="file" name="aadhar_pdf" id="aadhar_pdf" class="form-control" 
                                   accept=".pdf,.jpg,.jpeg,.png" required>
                            <div id="aadhar-name-display" class="file-name"></div>
                        </div>
                        <small class="text-muted">
                            <i class="fas fa-info-circle me-1"></i>आधार कार्ड अपलोड करें
                        </small>
                    </div>
                </div>
            </div>

            <div class="info-box">
                <i class="fas fa-shield-alt"></i>
                <p class="mb-0"><strong>Service Charge:</strong> ₹<?php echo number_format($service_fee, 2); ?></p>
                <small>Amount will be deducted from your wallet</small>
                <p class="mb-0 mt-2" style="font-size: 0.9rem;">
                    📱 आपके PAN Card तैयार होने पर WhatsApp पर सूचित किया जाएगा।
                </p>
            </div>

            <button type="submit" name="apply" class="btn btn-submit mt-3">
                <i class="fas fa-paper-plane me-2"></i>Submit Application
            </button>
        </form>

        <div class="text-center mt-4">
            <a href="pan-list.php" class="text-decoration-none">
                <i class="fas fa-history me-1"></i>View Applications
            </a>
        </div>
    </div>
</div>

<script>
// Phone number validation
document.querySelector('input[name="phone"]').addEventListener('input', function(e) {
    this.value = this.value.replace(/[^0-9]/g, '');
});

// PIN code validation
document.querySelector('input[name="pincode"]').addEventListener('input', function(e) {
    this.value = this.value.replace(/[^0-9]/g, '');
});

// Photo file input change - show file name
document.getElementById('photo').addEventListener('change', function(e) {
    if (this.files && this.files[0]) {
        document.getElementById('photo-label-text').textContent = 'File Selected: ' + this.files[0].name;
        document.getElementById('photo-name-display').textContent = '📎 ' + this.files[0].name;
    } else {
        document.getElementById('photo-label-text').textContent = 'Click to upload Photo';
        document.getElementById('photo-name-display').textContent = '';
    }
});

// Signature file input change - show file name
document.getElementById('sin_document').addEventListener('change', function(e) {
    if (this.files && this.files[0]) {
        document.getElementById('sign-label-text').textContent = 'File Selected: ' + this.files[0].name;
        document.getElementById('sign-name-display').textContent = '📎 ' + this.files[0].name;
    } else {
        document.getElementById('sign-label-text').textContent = 'Click to upload Signature';
        document.getElementById('sign-name-display').textContent = '';
    }
});

// Aadhar file input change - show file name
document.getElementById('aadhar_pdf').addEventListener('change', function(e) {
    if (this.files && this.files[0]) {
        document.getElementById('aadhar-label-text').textContent = 'File Selected: ' + this.files[0].name;
        document.getElementById('aadhar-name-display').textContent = '📎 ' + this.files[0].name;
    } else {
        document.getElementById('aadhar-label-text').textContent = 'Click to upload Aadhar';
        document.getElementById('aadhar-name-display').textContent = '';
    }
});
</script>

<?php include('../footer.php'); ?>
</body>
</html>
